<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTable extends Migration {

	public function up()
	{
		Schema::create('category', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('category_name', 191);
			$table->string('image', 191)->nullable();
			$table->string('url', 191);
			$table->enum('status', array('Active', 'Inactive'));
		});
	}

	public function down()
	{
		Schema::drop('category');
	}
}