<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePegawaiTable extends Migration {

	public function up()
	{
		Schema::create('pegawai', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 15);
			$table->string('nik', 20)->nullable();
			$table->string('nip', 20);
			$table->string('name', 100);
			$table->string('email', 20)->nullable();
			$table->string('religion', 10);
			$table->string('msisdn', 20);
			$table->string('gender')->default('10');
			$table->integer('status_meried');
			$table->integer('golongan_id')->unsigned()->nullable();
			$table->integer('jabatan_id')->unsigned();
			$table->text('birthplace')->nullable();
			$table->date('birthdate');
			$table->text('address');
			$table->integer('status')->default('0');
			$table->timestamps();
			$table->string('photo', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('pegawai');
	}
}