<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('photo', 'title', 'price', 'quantity', 'description', 'status');

	public function photos()
	{
		return $this->hasMany('ProductPhoto');
	}

	public function orders()
	{
		return $this->belongsToMany('Order');
	}

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function reviews()
	{
		return $this->hasMany('Review');
	}

}