<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyTable extends Migration {

	public function up()
	{
		Schema::create('property', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('1', '2'))->nullable();
			$table->string('name')->nullable();
			$table->integer('permit_number')->nullable();
			$table->integer('landloard')->unsigned()->nullable();
			$table->enum('category', array('1', '2'))->nullable();
			$table->string('developer')->nullable();
			$table->enum('area_unit', array('1', '2'))->nullable();
			$table->string('area')->nullable();
			$table->string('country')->nullable();
			$table->string('city')->nullable();
			$table->integer('area_id')->unsigned()->nullable();
			$table->integer('post_code')->nullable();
			$table->integer('street_Number');
			$table->string('street_name')->nullable();
			$table->integer('property_number')->nullable();
			$table->integer('unit_number')->nullable();
			$table->integer('unit_floor')->nullable();
			$table->integer('unit_beds')->nullable();
			$table->integer('washrooms')->nullable();
			$table->integer('unit_rent')->nullable();
			$table->enum('maids_room', array('0', '1'))->nullable();
			$table->enum('balcony', array('0', '1'))->nullable();
			$table->enum('view_of_watch', array('1', '2'))->nullable();
			$table->enum('central_A_C', array('1', '2'))->nullable();
			$table->enum('walk_in_closet', array('1', '2'))->nullable();
			$table->enum('privat_pool', array('0', '1'))->nullable();
			$table->enum('built_in_kitchen', array('0', '1'))->nullable();
			$table->enum('built_in_ward', array('0', '1'))->nullable();
			$table->string('image', 500)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('property');
	}
}