<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('journey_id')->references('id')->on('journeys')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('launch_station_id')->references('id')->on('stations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('arival_station_id')->references('id')->on('stations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('seat_id')->references('id')->on('seats')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stationables', function(Blueprint $table) {
			$table->foreign('station_id')->references('id')->on('stations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_journey_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_client_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_launch_station_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_arival_station_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_seat_id_foreign');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->dropForeign('journeys_driver_id_foreign');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->dropForeign('journeys_trip_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_driver_id_foreign');
		});
		Schema::table('stationables', function(Blueprint $table) {
			$table->dropForeign('stationables_station_id_foreign');
		});
	}
}