<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->float('price');
			$table->integer('serial')->nullable();
			$table->float('delivery_price');
			$table->float('total_price');
			$table->enum('proccess', array('preparing', 'delivery', 'done'));
			$table->date('deliveried_date')->nullable();
			$table->integer('adress_id')->unsigned();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}