<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email')->unique();
			$table->string('verified_code', 255);
			$table->string('password', 255);
			$table->enum('role', array('admin', 'seller', 'user'));
			$table->string('phone', 15);
			$table->string('phone_verified')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}