<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contract_types', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('time', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_role')->references('role_id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_fiche')->references('id')->on('salaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_leave')->references('id')->on('user_leaves')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contract_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Permession_Role', function(Blueprint $table) {
			$table->foreign('id_role')->references('role_id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Permession_Role', function(Blueprint $table) {
			$table->foreign('id_permession')->references('id')->on('Permession')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_leaves', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_leaves', function(Blueprint $table) {
			$table->foreign('leave_type_id')->references('id')->on('leave_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salaires', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salary_components', function(Blueprint $table) {
			$table->foreign('contract_type_id')->references('id')->on('contract_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salary_components', function(Blueprint $table) {
			$table->foreign('logs_id')->references('id')->on('time')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salaries_salary_components', function(Blueprint $table) {
			$table->foreign('salary_id')->references('id')->on('salaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salaries_salary_components', function(Blueprint $table) {
			$table->foreign('id_salaire_composant')->references('id')->on('salaries_salary_components')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('contract_types', function(Blueprint $table) {
			$table->dropForeign('contract_types_employee_id_foreign');
		});
		Schema::table('time', function(Blueprint $table) {
			$table->dropForeign('time_user_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_role_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_fiche_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_leave_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_contract_id_foreign');
		});
		Schema::table('Permession_Role', function(Blueprint $table) {
			$table->dropForeign('Permession_Role_id_role_foreign');
		});
		Schema::table('Permession_Role', function(Blueprint $table) {
			$table->dropForeign('Permession_Role_id_permession_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_user_id_foreign');
		});
		Schema::table('user_leaves', function(Blueprint $table) {
			$table->dropForeign('user_leaves_user_id_foreign');
		});
		Schema::table('user_leaves', function(Blueprint $table) {
			$table->dropForeign('user_leaves_leave_type_id_foreign');
		});
		Schema::table('salaires', function(Blueprint $table) {
			$table->dropForeign('salaires_user_id_foreign');
		});
		Schema::table('salary_components', function(Blueprint $table) {
			$table->dropForeign('salary_components_contract_type_id_foreign');
		});
		Schema::table('salary_components', function(Blueprint $table) {
			$table->dropForeign('salary_components_logs_id_foreign');
		});
		Schema::table('salaries_salary_components', function(Blueprint $table) {
			$table->dropForeign('salaries_salary_components_salary_id_foreign');
		});
		Schema::table('salaries_salary_components', function(Blueprint $table) {
			$table->dropForeign('salaries_salary_components_id_salaire_composant_foreign');
		});
	}
}