<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 32);
			$table->string('last_name', 32);
			$table->string('username', 32);
			$table->string('email', 32);
			$table->integer('phone_number');
			$table->string('email_verified_at', 255)->nullable();
			$table->string('password', 32);
			$table->string('address');
			$table->string('receiver_address', 128)->nullable();
			$table->string('role', 32);
			$table->string('image', 64);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}