<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'Category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slug', 'parent_id', 'status');

	public function CategoryAttribute()
	{
		return $this->hasMany('App\Models\Attribute', 'attribute_id');
	}

}