<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderLinesTable extends Migration {

	public function up()
	{
		Schema::create('order_lines', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('order_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->decimal('qty', 10,2)->default('0');
			$table->decimal('price', 18,2)->default('0');
			$table->decimal('amount', 18,2)->default('0');
			$table->decimal('discount', 18,2)->default('0');
			$table->decimal('total_amount', 18,2)->default('0');
			$table->decimal('qty_return', 10,2)->default('0');
			$table->decimal('amount_return', 18,2)->default('0');
			$table->decimal('grand_total', 18,2)->default('0');
			$table->integer('created_by')->unsigned()->default('0');
			$table->integer('updated_by')->unsigned()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_lines');
	}
}