<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlafondsTable extends Migration {

	public function up()
	{
		Schema::create('plafonds', function(Blueprint $table) {
			$table->increments('id');
			$table->string('no_anggota', 10);
			$table->decimal('plafond_limit', 18,2)->default('0');
			$table->decimal('allocated', 18,2)->default('0');
			$table->decimal('balance', 18,2)->default('0');
			$table->date('period_start');
			$table->date('period_end');
			$table->boolean('is_active')->default(true);
			$table->integer('created_by')->default('0');
			$table->integer('updated_by')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plafonds');
	}
}