<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('productcollection_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart_lines', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cashiers', function(Blueprint $table) {
			$table->foreign('cashiercash_id')->references('id')->on('cashier_cash')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cashier_lines', function(Blueprint $table) {
			$table->foreign('cashier_id')->references('id')->on('cashiers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cashier_lines', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pre_orders', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->foreign('purchaserequest_id')->references('id')->on('purchases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_collections', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_collections', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_productcollection_id_foreign');
		});
		Schema::table('cart_lines', function(Blueprint $table) {
			$table->dropForeign('cart_lines_product_id_foreign');
		});
		Schema::table('cashiers', function(Blueprint $table) {
			$table->dropForeign('cashiers_cashiercash_id_foreign');
		});
		Schema::table('cashier_lines', function(Blueprint $table) {
			$table->dropForeign('cashier_lines_cashier_id_foreign');
		});
		Schema::table('cashier_lines', function(Blueprint $table) {
			$table->dropForeign('cashier_lines_product_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_order_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_product_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_product_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_location_id_foreign');
		});
		Schema::table('pre_orders', function(Blueprint $table) {
			$table->dropForeign('pre_orders_product_id_foreign');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->dropForeign('purchase_lines_product_id_foreign');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->dropForeign('purchase_lines_purchaserequest_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_product_id_foreign');
		});
		Schema::table('product_collections', function(Blueprint $table) {
			$table->dropForeign('product_collections_category_id_foreign');
		});
		Schema::table('product_collections', function(Blueprint $table) {
			$table->dropForeign('product_collections_brand_id_foreign');
		});
	}
}