<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediasTable extends Migration {

	public function up()
	{
		Schema::create('medias', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->string('media_name', 255);
			$table->string('media_path', 255);
			$table->integer('position');
			$table->integer('created_by')->default('0');
			$table->integer('updated_by')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('medias');
	}
}