<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrizesTable extends Migration {

	public function up()
	{
		Schema::create('prizes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('description');
			$table->datetime('winner_moment_start');
			$table->datetime('winner_moment_end')->nullable();
			$table->boolean('active')->default(1);
			$table->boolean('delivered')->default(0);
			$table->integer('category_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('prizes');
	}
}