<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('prizes', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('prize_category')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('campaign', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('participations', function(Blueprint $table) {
			$table->foreign('participant_id')->references('id')->on('participants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('participations', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('participations', function(Blueprint $table) {
			$table->foreign('prize_id')->references('id')->on('prizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prize_category', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('prizes', function(Blueprint $table) {
			$table->dropForeign('prizes_category_id_foreign');
		});
		Schema::table('campaign', function(Blueprint $table) {
			$table->dropForeign('campaign_company_id_foreign');
		});
		Schema::table('participations', function(Blueprint $table) {
			$table->dropForeign('participations_participant_id_foreign');
		});
		Schema::table('participations', function(Blueprint $table) {
			$table->dropForeign('participations_campaign_id_foreign');
		});
		Schema::table('participations', function(Blueprint $table) {
			$table->dropForeign('participations_prize_id_foreign');
		});
		Schema::table('prize_category', function(Blueprint $table) {
			$table->dropForeign('prize_category_campaign_id_foreign');
		});
	}
}