<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Employee extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;
    protected $fillable = array('lastname', 'firstname', 'mail', 'service_id', 'img', 'phone');

    public function service()
    {
        return $this->belongsTo('App\Service');
    }

    public function assignements()
    {
        return $this->hasMany('App\Assignement');
    }

    public function reports()
    {
        return $this->hasMany('App\Report');
    }

}