<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;
    protected $fillable = array('name', 'description', 'customer_id');

    public function customer()
    {
        return $this->belongsTo('App\Customer');
    }

    public function tasks()
    {
        return $this->hasMany('App\Task');
    }

}