<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;
    protected $fillable = array('description', 'img');

    public function employees()
    {
        return $this->hasMany('App\Employee');
    }

    public function reports()
    {
        return $this->hasManyThrough('App\Report', 'App\Employee');
    }

}