<?php

namespace App;

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;
	protected $fillable = array('lastname', 'firstname', 'mail', 'service_id', 'img', 'phone');

	public function service()
	{
		return $this->belongsTo('App\Service');
	}

	public function assignements()
	{
		return $this->hasMany('App\Assignement');
	}

	public function reports()
	{
		return $this->hasMany('App\Report');
	}

}