<?php

namespace App;

class Task extends Eloquent {

	protected $table = 'tasks';
	public $timestamps = true;
	protected $fillable = array('name', 'description', 'state_id', 'project_id');

	public function state()
	{
		return $this->belongsTo('App\State');
	}

	public function project()
	{
		return $this->belongsTo('App\Project');
	}

	public function assignements()
	{
		return $this->hasMany('App\Assignement');
	}

	public function reports()
	{
		return $this->hasMany('App\Report');
	}

}