<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ArtProject extends Eloquent {

	protected $table = 'art_project';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'artist_id', 'software_id', 'technology_id', 'name', 'views', 'launched');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function artist()
	{
		return $this->belongsTo('Artist', 'artist_id');
	}

	public function software()
	{
		return $this->belongsTo('Software', 'software_id');
	}

	public function technology()
	{
		return $this->belongsTo('Technology', 'technology_id');
	}

	public function likes()
	{
		return $this->hasMany('ArtProjectLike', 'art_project_id');
	}

}