<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ArtProjectLike extends Eloquent {

	protected $table = 'art_project_like';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'art_project_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function art_project()
	{
		return $this->belongsTo('ArtProject', 'art_project_id');
	}

}