<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Artist extends Eloquent {

	protected $table = 'artist';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'about', 'hired', 'views');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}