<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Collection extends Eloquent {

	protected $table = 'collection';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'width', 'height', 'description', 'website', 'network_id', 'user_id', 'symbol', 'size', 'metadata_cid', 'preview_tokens', 'is_generated');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function network()
	{
		return $this->belongsTo('Collection', 'network_id');
	}

	public function generated_tokens()
	{
		return $this->hasMany('CollectionToken', 'collection_id');
	}

	public function contracts()
	{
		return $this->hasMany('Contract', 'collection_id');
	}

	public function custom_tokens()
	{
		return $this->hasMany('CustomToken', 'collection_id');
	}

}