<?php

namespace Api;

class CollectionToken extends Eloquent {

	protected $table = 'collection_token';
	public $timestamps = true;
	protected $fillable = array('collection_id', 'image', 'metadata', 'edition');

	public function collection()
	{
		return $this->belongsTo('Collection', 'collection_id');
	}

	public function items()
	{
		return $this->belongsToMany('TokenItem', 'items', 'item_id', 'token_id');
	}

}