<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'group';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('collection_id', 'name', 'size', 'is_main');

	public function collection()
	{
		return $this->belongsTo('Collection', 'collection_id');
	}

	public function layers()
	{
		return $this->belongsToMany('Layer', 'group_layer', 'layer_id', 'group_id');
	}

}