<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Item extends Eloquent {

	protected $table = 'item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('layer_id', 'name', 'rarity');

	public function layer()
	{
		return $this->belongsTo('Layer', 'layer_id');
	}

	public function categories()
	{
		return $this->belongsToMany('Category', 'item_category', 'item_id', 'category_id');
	}

	public function attributes()
	{
		return $this->belongsToMany('Item', 'item_ttributea', 'item_id', 'attribute_id');
	}

}