<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ItemCategory extends Eloquent {

	protected $table = 'item_category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('item_id', 'category_id');

	public function item()
	{
		return $this->belongsTo('Item', 'item_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}