<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Layer extends Eloquent {

	protected $table = 'layer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('collection_id', 'rarity', 'name', 'is_override');

	public function collection()
	{
		return $this->belongsTo('Collection', 'collection_id');
	}

	public function groups()
	{
		return $this->belongsToMany('Group', 'group_layer', 'layer_id', 'group_id');
	}

}