<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MetadataCid extends Eloquent {

	protected $table = 'metadata_cid';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cid', 'collection_id');

	public function collection()
	{
		return $this->belongsTo('Collection', 'collection_id');
	}

}