<?php

namespace social;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Social extends Eloquent {

	protected $table = 'social';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'link', 'platform');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}