<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WhiteList extends Eloquent {

	protected $table = 'white_list';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('collection_id', 'server_id');

	public function collection()
	{
		return $this->belongsTo('Collection', 'collection_id');
	}

}