<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WhiteListUser extends Eloquent {

	protected $table = 'white_list_user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('white_list_id', 'address', 'validated', 'source', 'username', 'userid', 'signature');

	public function white_list()
	{
		return $this->belongsTo('WhiteList', 'white_list_id');
	}

}