<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WithdrawalAddress extends Eloquent {

	protected $table = 'withdrawal_address';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('address', 'contract_id', 'share');

	public function contract()
	{
		return $this->belongsTo('Contract', 'contract_id');
	}

}