<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Artist extends Model 
{

    protected $table = 'artist';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'about', 'hired', 'views');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}