<?php

namespace WorkingScope;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkingScope extends Model 
{

    protected $table = 'working_scopes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function vendors()
    {
        return $this->belongsToMany('Vendor');
    }

    public function countries()
    {
        return $this->belongsToMany('User');
    }

}