<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('logo');
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('governate_id')->unsigned();
			$table->bigInteger('city_id')->unsigned();
			$table->text('address');
			$table->string('phone');
			$table->string('whatsapp');
			$table->string('url');
			$table->text('description');
			$table->string('id_front_image');
			$table->string('id_back_image');
			$table->boolean('active')->default(1);
			$table->bigInteger('user_id')->unsigned();
			$table->enum('type', array('shop', 'factory'));
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}