<?php

namespace WorkingScope;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WorkingScope extends Eloquent {

	protected $table = 'working_scopes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function vendors()
	{
		return $this->belongsToMany('Vendor');
	}

	public function countries()
	{
		return $this->belongsToMany('User');
	}

}