<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFriendshipsTable extends Migration {

	public function up()
	{
		Schema::create('friendships', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('friend_id')->unsigned();
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('friendships');
	}
}