<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCardTable extends Migration {

	public function up()
	{
		Schema::create('card', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('number')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('expired_at')->nullable();
			$table->enum('status', array('inactive', 'active', 'pending'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('card');
	}
}