<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponTable extends Migration {

	public function up()
	{
		Schema::create('coupon', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('offer_id')->nullable();
			$table->string('number')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->integer('discount')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->datetime('expired_at')->nullable();
			$table->enum('status', array('active', 'inactive'))->nullable();
			$table->integer('max_uses')->nullable();
			$table->integer('uses')->nullable();
			$table->integer('current_uses')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('coupon');
	}
}