<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Offer extends Model 
{

    protected $table = 'offer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('city_id', 'category_id', 'company_id', 'discounts_en', 'discounts_ar', 'description_en', 'description_ar', 'have_coupons', 'video');

    public function coupons()
    {
        return $this->hasMany('Coupon', 'offer_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function company()
    {
        return $this->belongsTo('Company', 'company_id');
    }

}