<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTable extends Migration {

	public function up()
	{
		Schema::create('company', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('address_en')->nullable();
			$table->string('address_ar')->nullable();
			$table->double('latitude')->nullable();
			$table->double('longitude')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->text('whatsapp')->nullable();
			$table->text('facebook')->nullable();
			$table->text('twitter')->nullable();
			$table->text('instagram')->nullable();
			$table->text('snapchat')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('company');
	}
}