<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Card extends Model 
{

    protected $table = 'card';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('number', 'start_at', 'expired_at', 'status');

    public function users()
    {
        return $this->hasMany('User', 'card_id');
    }

}