<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Card extends Eloquent {

	protected $table = 'card';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('number', 'start_at', 'expired_at', 'status');

	public function users()
	{
		return $this->hasMany('User', 'card_id');
	}

}