<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'company';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'address_en', 'address_ar', 'latitude', 'longitude', 'phone', 'email', 'whatsapp', 'facebook', 'twitter', 'instagram', 'snapchat');

	public function cities()
	{
		return $this->belongsToMany('City', 'company_city', 'company_id', 'city_id');
	}

}