<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('user_name');
			$table->string('email');
			$table->string('email_verified_at')->nullable();
			$table->string('password');
			$table->bigInteger('innovator_id')->unsigned()->nullable();
			$table->integer('university_id');
			$table->integer('company_id')->unsigned();
			$table->integer('vc_id')->unsigned();
			$table->integer('mentor_id');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}