<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTable extends Migration {

	public function up()
	{
		Schema::create('Company', function(Blueprint $table) {
			$table->increments('id');
			$table->string('company_name');
			$table->string('company_website');
			$table->integer('country_id')->unsigned();
			$table->string('city');
			$table->string('title');
			$table->string('name');
			$table->string('position');
			$table->string('current_location');
			$table->string('country_code');
			$table->string('phone_number');
			$table->string('linkedin');
			$table->string('whatsapp');
			$table->integer('industry_id')->unsigned();
			$table->json('interest');
			$table->string('company_logo');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Company');
	}
}