<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarketConfigTable extends Migration {

	public function up()
	{
		Schema::create('market_config', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('market_id')->unsigned();
			$table->integer('investment_positive');
			$table->integer('investment_negative');
			$table->integer('investment_step');
			$table->integer('initial_user_wallet_value');
			$table->smallInteger('initial_user_portfolio_slots');
			$table->float('max_user_influence_percentage');
			$table->integer('max_user_influence_treshold');
			$table->float('min_investment_percentagem');
			$table->smallInteger('automatic_sales_days')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('market_config');
	}
}